#!/bin/bash
# Creates a copy of the source tree suitable for building under Win32 platforms.
# Requires a build copy of the s11n tree.

cat <<EOF
WARNING: THIS SCRIPT IS LARGELY UNTESTED!
EOF

target_dir=${PWD}/win32
test -d ${target_dir} || mkdir -p ${target_dir}

### Input source files
in_sources="
src/strtool/strtool.cpp
src/s11n/s11n.cpp
src/s11n/s11n_node.cpp
src/s11n/exception.cpp
src/s11n/export.hpp
src/io/data_node_io.cpp
src/io/compact/compact.flex.cpp
src/io/compact/compact_serializer.cpp
src/io/funtxt/funtxt.flex.cpp
src/io/funtxt/funtxt_serializer.cpp
src/io/funxml/funxml.flex.cpp
src/io/funxml/funxml_serializer.cpp
src/io/parens/parens.flex.cpp
src/io/parens/parens_serializer.cpp
src/io/simplexml/simplexml.flex.cpp
src/io/simplexml/simplexml_serializer.cpp
src/io/wesnoth/wesnoth.flex.cpp
src/io/wesnoth/wesnoth_serializer.cpp
src/lite/s11nlite.cpp
src/plugin/path_finder.cpp
src/plugin/plugin.cpp
src/plugin/plugin.win32.cpp
src/test.cpp
src/in.xml
"


echo "Copying headers to ${target_dir}/..."
tar cf - -h include/s11n.net | (
    cd ${target_dir} || exit
    tar xpf - || exit
)

echo "Copying sources to ${target_dir}/..."
srctgt=${target_dir}/src
test -d ${srctgt} || mkdir -p ${srctgt}
for s in ${in_sources}; do
     cp $s ${srctgt}/$(basename ${s}) || exit
done

cp README.WIN32 ${target_dir}

echo "Finished. Now please see the Win32-related build documentation in the file README.WIN32."
