%option c++
%{
//
// LICENSE: Public Domain
// Author: stephan - stephan@s11n.net
//

#define YY_SKIP_YYWRAP 1
int yywrap() { return 1; }

// #include <stdio.h>
#include <cassert>
#include <iostream>
#include <string>
#include <deque>

#include <s11n.net/s11n/s11n_debuggering_macros.hpp> // CERR
#define PCERR CERR << "compact.flex error:"

#include <s11n.net/strtool/strtool.hpp> // hex2int()
#include <s11n.net/s11n/io/data_node_io.hpp> // node_tree_builder
#include <s11n.net/s11n/io/compact_serializer.hpp> // compact_serializer

// #include <s11n.net/cl/cllite.hpp> // classloader framework
#include <s11n.net/s11n/io/compact_data_nodeFlexLexer.hpp>

#define S11N_FACREG_TYPE compact_data_nodeFlexLexer
#define S11N_FACREG_TYPE_NAME "compact_data_nodeFlexLexer"
#define S11N_FACREG_INTERFACE_TYPE FlexLexer
#include <s11n.net/s11n/factory_reg.hpp>
// cl_CLASSLOADER_REGISTER(FlexLexer,compact_data_nodeFlexLexer);

//////////////////////////////////////////////////////////////////////
// workarounds for the (very outdated) flex output:
using std::cin;
using std::cout;
using std::cerr;
using std::endl;
//////////////////////////////////////////////////////////////////////


/**
Basic grammar spec:

{NODE_OPEN}{NAME_SIZE}{NODE_NAME}<class_name_size>{CLASSNAME}
    ({PROP_OPEN}<key_size><key><value_size><value>)*
    (sub-nodes)*
{NODE_CLOSE}

See the lex source for the meanings of the {TOKENS} named above.
*/


namespace {
        std::string word;
        std::string propname;
        std::string propval;
        std::string nodename;
        std::string nodeclass;
        bool in_prop;
        unsigned int decval = 0;
        unsigned int lcv = 0;

        typedef s11n::io::tree_builder_context<
                s11n::io::sharing::compact_sharing_context
        > BuilderContext;



}



namespace {

        int property_value_size = 4; // number of bytes used to store property values.
        // this changed from 4 to 8 in version 0.5.3.

        char inchar; // buffer used by READWORD macro.
}

#define READWORD(SZ) word = ""; \
        for( int i = 0; i < SZ; i++ )\
        {\
                inchar = yyinput(); \
                if( 0 == inchar ) {word=""; PCERR << "Reached EOF during READWORD!" << std::endl; return 0;} \
                word += inchar; \
        };\
	decval = strtool::hex2int(word)

#define READVAL(STRINGVAR) \
        for( unsigned int lcv = 0; lcv < decval; lcv++ ) { STRINGVAR += yyinput(); }

%}

HEX_DIGIT		([a-fA-F0-9])
WORD4			({HEX_DIGIT}{4})

	// maintenance note: these hex codes must be kept in sync with those from compact_serializer's enum
NODE_OPEN		f1
NODE_CLOSE		f0
PROP_OPEN		e1
COOKIE4B		51191011
 // ^^^^ cookie for the 4-byte-size-tokens version
DATA_END		51191000

%%

{COOKIE4B} { // s11n 0.5.3 and higher
        property_value_size = 4;
        continue;
	}

{DATA_END} { return 0; }

([ \t\n])+ {;}

{NODE_OPEN} {
        //COUT << "Opening node." << std::endl;
        READWORD(2); // read node name size
        nodename = "";
        READVAL(nodename);
        //cout<< endl;
        READWORD(2); // get class name size
        nodeclass = "";
        READVAL(nodeclass);
        //COUT << "nodename=["<<nodename<<"]"<<"["<<nodeclass<<"]"<<endl;
        if( ! BuilderContext::open_node( this, nodeclass, nodename ) )
        {
                PCERR<< "open_node("<<nodeclass<<","<<nodename<<") failed." << std::endl;
                return 0;
        }
        nodename = nodeclass = "";
	}

{NODE_CLOSE} {
        //COUT << "Closing node." << std::endl;
        BuilderContext::close_node( this );
        if( 0 == BuilderContext::node_depth( this ) )
        {
                // stop once we close the first top-level node.
                return 0;
        }
        continue;
	}
{PROP_OPEN} {
        //COUTL( "Opening property" );
        propname = "";
        READWORD(2); // prop name size
        READVAL(propname);
        READWORD(property_value_size); // get value size
        propval = "";
        READVAL(propval);
        BuilderContext::add_property( this, propname, propval );
        propval = propname = "";
	}

[.] {
        PCERR << "unexpected token: " << YYText() <<std::endl;
        return 0;
	}

%%

#if COMPACT_DO_MAIN
int main( int argc, char ** argv )
{
        using namespace s11n;
        return 0;
}

#endif
