////////////////////////////////////////////////////////////////////////
// Win32-specific parts of plugin.{c,h}pp
//
// All Win32 code is 100% untested (i don't have Windows).
////////////////////////////////////////////////////////////////////////
#include <windows.h> // LoadModule().

namespace s11n { namespace plugin {

	static std::string m_windll_error; // internal holder for open() error string.

        std::string dll_error()
        {
		if( m_windll_error.empty() ) return m_windll_error;
		std::string ret = m_windll_error;
		m_windll_error = std::string();
		return ret;
        }

	std::string open( const std::string & basename )
	{
		std::string where = find( basename );
		if( where.empty() )
		{
			m_windll_error = std::string("s11n::plugin::open(")
				+ basename
				+ std::string( "): No DLL found.");
			return std::string();
		}
                LoadModule( where.c_str(), NULL ); // WTF does LoadModule() really return?
		// FIXME: find out if LoadModule() failed (how?) and then set error
		// string if needed.
		m_windll_error = std::string();
                return where;
	}

}} // namespace

