#if !defined(s11n_PODS_STREAMABLE_HPP_INCLUDED)
#define s11n_PODS_STREAMABLE_HPP_INCLUDED 1
////////////////////////////////////////////////////////////////////////
// pod.hpp: default POD proxies.
////////////////////////////////////////////////////////////////////////
// As an unofficial benchmark: disabling POD registration saves
// approximately 4 seconds of compile time on my 1.6GHz PC, for each
// client-side impl file which includes s11n.hpp or s11nlite.hpp.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////
// a set of default proxy installations used by the s11n framework
// License: Public Domain
// Author: stephan@s11n.net
////////////////////////////////////////////////////////////////////////

// s11n-related headers are assumed to have been included by now...

#error "Using this header is discouraged. Please include the specific proxy headers you need."

#include <s11n.net/s11n/serialize.hpp>
#include <s11n.net/s11n/algo.hpp> // s11n::streamable_type_serialization_proxy

#define S11N_PODS_STREAMABLE_PROXY s11n::streamable_type_serialization_proxy


#define S11N_TYPE char
#define S11N_TYPE_NAME "char"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>

#define S11N_TYPE bool
#define S11N_TYPE_NAME "bool"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>

#define S11N_TYPE int
#define S11N_TYPE_NAME "int"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>

#define S11N_TYPE size_t
#define S11N_TYPE_NAME "size_t"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>

#define S11N_TYPE float
#define S11N_TYPE_NAME "float"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>

#define S11N_TYPE double
#define S11N_TYPE_NAME "double"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>

#define S11N_TYPE long
#define S11N_TYPE_NAME "long"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>

// ulong should be the same as size_t...
// #define S11N_TYPE ulong
// #define S11N_TYPE_NAME "ulong"
// #define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
// #include <s11n.net/s11n/reg_s11n_traits.hpp>


#define S11N_TYPE std::string
#define S11N_TYPE_NAME "string"
#define S11N_SERIALIZE_FUNCTOR S11N_PODS_STREAMABLE_PROXY
#include <s11n.net/s11n/reg_s11n_traits.hpp>


#undef S11N_PODS_STREAMABLE_PROXY

#endif // s11n_PODS_STREAMABLE_HPP_INCLUDED
