// a supermacro to generate some partial template specializations for list-type classes.

#ifndef S11N_LIST_TYPE
#error "You must define S11N_LIST_TYPE before including this file. e.g., to std::list or std::vector."
#endif

#ifndef S11N_LIST_TYPE_NAME
#error "You must define S11N_LIST_TYPE_NAME before including this file. e.g., to \"list\" or \"vector\"."
#endif

#ifndef S11N_LIST_TYPE_PROXY
#define S11N_LIST_TYPE_PROXY ::s11n::list::list_serializable_proxy
#endif


namespace s11n {


        /**
           s11n_traits<> specialization for std::list types.
        */
        template <typename ValT >
        struct s11n_traits < S11N_LIST_TYPE< ValT > >
        {
                typedef S11N_LIST_TYPE< ValT > serializable_type;
                typedef S11N_LIST_TYPE_PROXY serialize_functor;
                typedef serialize_functor deserialize_functor;
                typedef ::s11n::cl::object_factory<serializable_type> factory_type;
		static const bool cl_reg_placeholder;
		static std::string class_name( const serializable_type * instance_hint )
		{
			if( cl_reg_placeholder == true ); // just to reference it. w/o this cl reg never happens :(
			return S11N_LIST_TYPE_NAME;
		}

        };
	template < typename VT > 
	const bool s11n_traits<
		S11N_LIST_TYPE< VT >
		>::cl_reg_placeholder =
		(
		 ::s11n::cl::classloader_register_base< S11N_LIST_TYPE< VT > >(s11n_traits< S11N_LIST_TYPE< VT > >::class_name(0)),
		 true
		 ) ;
} // namespace s11n

#undef S11N_LIST_TYPE_PROXY
#undef S11N_LIST_TYPE_NAME
#undef S11N_LIST_TYPE
