////////////////////////////////////////////////////////////////////////
// A supermacro to generate some partial template specializations for
// map-type classes. Coincidentally, it also works for std::pair-like
// types.
////////////////////////////////////////////////////////////////////////

#ifndef S11N_MAP_TYPE
#error "You must define S11N_MAP_TYPE before including this file. e.g., to std::map or std::multimap."
#endif

#ifndef S11N_MAP_TYPE_NAME
#error "You must define S11N_MAP_TYPE_NAME before including this file. e.g., to \"map\" or \"multimap\"."
#endif

#ifndef S11N_MAP_TYPE_PROXY
#define S11N_MAP_TYPE_PROXY ::s11n::map::map_serializable_proxy
#endif


namespace s11n {


        /**
           s11n_traits<> specialization for std::map types.
        */
        template <typename KeyT, typename ValT>
        struct s11n_traits < S11N_MAP_TYPE<KeyT,ValT> >
        {
                typedef S11N_MAP_TYPE<KeyT,ValT> serializable_type;
                typedef S11N_MAP_TYPE_PROXY serialize_functor;
                typedef serialize_functor deserialize_functor;
                typedef ::s11n::cl::object_factory<serializable_type> factory_type;
		static bool cl_reg_placeholder; 
		static std::string class_name( const serializable_type * instance_hint )
		{
 			if( cl_reg_placeholder == true ); // just to reference it. w/o this cl reg never happens :(
			return S11N_MAP_TYPE_NAME;
		}
        };
	template <
		typename KT,
		typename VT
		>
	bool s11n_traits<
		S11N_MAP_TYPE< KT, VT >
		>::cl_reg_placeholder = (
					  ::s11n::cl::classloader_register_base< S11N_MAP_TYPE< KT, VT > >(S11N_MAP_TYPE_NAME),
					  true
					  );


} // namespace s11n


#undef S11N_MAP_TYPE_PROXY
#undef S11N_MAP_TYPE_NAME
#undef S11N_MAP_TYPE
