#include <s11n.net/s11n/exception.hpp>
#include <sstream>

// #include <s11n.net/s11n/s11n_debuggering_macros.hpp> // CERR
// #include <iostream>

namespace s11n {


	s11n_exception::s11n_exception( const std::string & What ) : m_what(What)
	{
	}

	const char * s11n_exception::what() const throw()
	{
		return this->m_what.c_str();
	}

        s11n_exception::s11n_exception( const std::string & what,
					const std::string & file,
					unsigned int line )
        {
                std::ostringstream os;
                os << file << ":"<<line<<": " << what;
                this->m_what = os.str();
        }


	throw_policy_mask s11n_internal_throw_policy = ThrowDefaultPolicy;

	throw_policy_mask throw_policy( throw_policy_mask m ) throw()
	{
		throw_policy_mask old = s11n_internal_throw_policy;
		s11n_internal_throw_policy = m;
		return old;
	}

	throw_policy_mask throw_policy() throw()
	{
		return s11n_internal_throw_policy;
	}

	void potentially_throw( throw_policy_mask condition,
				const std::string & errstring )
	{
		throw_policy_mask m = throw_policy();
		// CERR << "potentially_throw("<<std::hex<<"(policy==0x"<<m<<" & condition==0x"<<std::hex<<condition<<")"<<std::dec<<","<<errstring<<").\n";
		if( ! (m & condition) ) return;
		if( condition & ThrowOnIOError )
		{
			throw io_exception( errstring );
		}
		else if( condition & ThrowOnFactoryError )
		{
			throw s11n_exception( errstring );
		}

		throw s11n_exception( errstring );
	}

	void potentially_throw( throw_policy_mask condition, const std::string & errstring,
				const std::string & filename, unsigned int lineno )
	{
		std::ostringstream os;
		os << filename << ":" << lineno << ": " << errstring;
		potentially_throw( condition, os.str() );
	}


	throw_policy_changer::throw_policy_changer( throw_policy_mask mask,
						    bool override )
		: m_oldmask(throw_policy())
	{
		throw_policy( override ? mask : (mask|m_oldmask) );
	}
	throw_policy_changer::~throw_policy_changer() throw()
	{
		throw_policy( this->m_oldmask );
	}


} // namespace s11n
