#!/bin/sh
# builds and installs all s11n-related libs


prefix=${1?"Usage: $0 /install/path/prefix [optional args for configure scripts]"}
shift

libs_noconf="libname_type++ libphoenix++ libtostring++ libs11n_lex_t++ libs11n_sigslot"
libs_conf="libs11n_stringutil libs11n_zfstream libs11n_acme libs11n_class_loader libs11n-"


echo prefix=$prefix


for l in $libs_noconf; do
    dn=$(ls -d ${l}*)
    test x = "x$dn" && {
        echo "Error: didn't find lib $l"
        exit 1
    }
    echo "Installing $dn..."
    cd $dn
    make install prefix=$prefix "$@" || {
        echo "Error installing $dn!"
        exit 4
    }
    cd -
done

make=$(which make 2>/dev/null)
test x = "x$make" && make=$(which gmake 2>/dev/null)
test x = "x$make" && {
    echo "Error: 'make' not found in PATH!"
    exit 5
}

for l in $libs_conf; do
    dn=$(ls -d ${l}*)
    test x = "x$dn" && {
        echo "Error: didn't find lib $l"
        exit 1
    }
    echo "Building and installing $dn..."
    cd $dn
    ./configure --prefix=$prefix "$@" || {
        echo "Error configuring $dn!"
        exit 2
    }
    ${make} || {
        echo "Error building $dn!"
        exit 3
    }
    ${make} install || {
        echo "Error installing $dn!"
        exit 4
    }
    cd -
    echo "Built/installed $dn!"
done

