#!/bin/sh
# Installs files from under $PWD/debian/tmp. It first patches some
# generated files so that the install prefix is correct.  Intended for
# use by martin krafft and Debian-based install.

env > foo
export prefix
# where debian_build.sh installs to:
debprefix=$PWD/debian/tmp

test -e $debprefix/include/s11n.net/phoenix/phoenix.hpp || {
    echo "It seems you haven't yet run ./debian_build.sh!"
    exit 1
}


if test x = "x$prefix"; then
    prefix=/usr
fi

echo "prefix=$prefix"

test -d "$prefix" || {
    mkdir -p "$prefix" || {
        echo "Error creating prefix dir $prefix!"
        exit 3
    }
}

echo "Patching the prefix in XXX-config..."
cd $debprefix/bin
perl -i -pe "s|prefix=.+|prefix=\"$prefix\"|;s|$debprefix|$prefix|g" *-config
cd -
echo "Patching up any absolute paths in headers..."
cd $debprefix/
find . -type f -name '*.hpp' | xargs perl -i -pe "s|$debprefix|$prefix|g"
cd -


# install files to prefix....
cd $debprefix
echo "Installing to $prefix..."
tar cf - $(find . | perl -pe 's|^\./?||' | sed -e '/^$/d' ) | tar xvf - -C $prefix
cd -


