////////////////////////////////////////////////////////////////////////
// The NAME_TYPE mechanism is far, far supperior to the CLASS_NAME()
// macro, as it can handle ANY type name.
// It does not have a multi-include guard, as it's usage does not
// call for one.
////////////////////////////////////////////////////////////////////////
#include <string>

#ifndef NAME_TYPE
#    error "You must set both NAME_TYPE and TYPE_NAME before including this supermacro."
#endif // NAME_TYPE

#ifndef TYPE_NAME
#    error "You must set both NAME_TYPE and TYPE_NAME before including this supermacro."
// todo: test this fix from martin here, so we don't have to set TYPE_NAME:
// #  #define TYPE_NAME #NAME_TYPE
#endif

#include "class_name.hpp"

namespace {

        template <>
        struct class_name< NAME_TYPE  >
        { 
                static const char * name() { 
                        return TYPE_NAME;
                }
        };
        template <>
        struct class_name< const NAME_TYPE  >
        { 
                static const char * name() { 
                        return TYPE_NAME;
                }
        };
        template <>
        struct class_name< NAME_TYPE *  >
        { 
                static const char * name() { 
                        return TYPE_NAME;
                }
        };

        template <>
        struct class_name< const NAME_TYPE *  >
        { 
                static const char * name() { 
                        return TYPE_NAME;
                }
        };

}
#undef NAME_TYPE
#undef TYPE_NAME

