//
// proxied_struct.cpp
//
//
// a minimal example showing how to use s11nlite to
// store an STL vector containing user structs
//
// In this case, we won't add serialization functions into
// the structs/classes, but will add proxy functors.
// The advantage of this approach is minimal alteration
// to existing structs/classes
//
// compiles with:
// g++ -o proxied_struct proxied_struct.cpp -I../../../include -L../../../lib 
//  -ls11n

#define cl_CLASSLOADER_DEBUG 1

#include "proxied_struct.h"


#ifdef NDEBUG
#  undef NDEBUG
#endif
#include <cassert>

#include <sstream>
#include <valarray>

#include <s11n.net/s11n/valarray.hpp>
bool test_valarray()
{
        typedef std::valarray<double> VA;

        size_t sz = 10;
        VA v(sz);
        for( size_t i = 0; i < sz; i++ )
        {
                v[i] = (1+i) * i;
        }

        typedef s11nlite::node_type NT;

        NT node;
        s11n::va::serialize_valarray( node, v );

        std::ostringstream os;
        s11nlite::save( node, os );
        CERR << "Serialized valarray:\n" << os.str();
        std::istringstream is( os.str() );

        VA * dev = s11nlite::load_serializable<VA>( is );
        assert( dev && "could not deserialize valarray<> type!" );
        CERR << "Deserialized valarray:\n";
        s11nlite::save( *dev, std::cout );
        delete( dev );


        return true;
}


int main()
{
  // first, show that the proxied struct does serialize
  elem_t e(34, 34.5);
  s11nlite::save(e, std::cout);  


  test_valarray();

  // now try to create a vector of the elem_t and serialize it
  SparseVector v;
  v.add_element(13, 2.3);
  v.add_element(23, 0.3);
  v.add_element(45, 0.13);
  std::cout << "  vector to serialize:" << std::endl;
  v.print();

  // write serialization to cout
  //s11n/s11nlite::save(v, std::cout);


  // serialize the object to disk
  s11nlite::save(v, "my_saved_vect.s11n");


  // okay, let's read it back in...
  SparseVector *v2 = s11nlite::load_serializable<SparseVector>("my_saved_vect.s11n");
  assert(v2);
  std::cout << "  deserialized vector:" << std::endl;
  // write to cout
  //s11n/s11nlite::save(*v2, std::cout);
  v2->print();
  delete v2;




  return 0;
}

