#include <s11n.net/s11n/s11nlite.hpp>
#include <s11n.net/s11n/pods_streamable.hpp>
#include <s11n.net/acme/argv_parser.hpp>
#include <cassert>
#include <utility> // pair

#include <s11n.net/s11n/map.hpp>

int main(int argc, char *argv[])
{
        //cout << "Hello, World!" << endl;

        acme::argv_parser& args = acme::argv_parser::args(argc,argv);
        if (args.is_set("d"))
                cl::class_loader_debug_level(1);

        if (args.is_set("s"))
                s11nlite::serializer_class( args.get( "s", s11nlite::serializer_class() ) );


        typedef std::map<int,int> mapii;

        mapii map;

        for( int i = 0; i < 5; i++ )
        {
                map.insert( std::make_pair( i, i*i ) );
        }

        //    mapii* p = s11nlite::load_serializable<mapii>("0.dat");

        //  //    mapii * clone = s11nlite::clone( V );
        //    assert( p );
        //    s11nlite::save( p, std::cout );
        //    delete( p );

        //    return 0;

        std::string tfile = "0.dat";

        CERR << "saving...\n";
        bool b=s11nlite::save(map,tfile);
        if (!b)
        {
                fprintf(stderr,"err save\n");
                return 1;
        }
        s11nlite::save( map, std::cout );

        CERR << "loading...\n";
        mapii* p = s11nlite::load_serializable<mapii>(tfile);
        if (!p)
        {
                fprintf(stderr,"err load\n");
                return 1;
        }
        s11nlite::save( p, std::cout );
        delete p;

        return EXIT_SUCCESS;
}

