#ifdef NDEBUG
#  undef NDEBUG // want assert() to always work
#endif

#include <cassert>
#include <utility> // pair


#include <s11n.net/cl/class_loader.hpp>

#include <s11n.net/s11n/s11nlite.hpp>
#include <s11n.net/s11n/pods_streamable.hpp>
#include <s11n.net/acme/argv_parser.hpp>


#include <s11n.net/s11n/traits.hpp>
#include <s11n.net/s11n/s11n_node.hpp>


#define NODE_TYPE s11nlite::node_type
// #define NODE_TYPE s11n::s11n_node



acme::argv_parser args;

// test class
struct AType
{
        AType() : classname("AType") {}
        virtual ~AType() {}

        std::string name;
        int id;
        std::string classname;

        virtual bool operator()( NODE_TYPE & dest ) const
        {
                typedef s11n::node_traits<NODE_TYPE> NT;
                NT::class_name( dest, this->classname );
                NT::set( dest, "AType_set_this", 1 );
                NT::set( dest, "name", this->name );
                NT::set( dest, "id", this->id );
                return true;
        }

        virtual bool operator()( const NODE_TYPE & src )
        {
                typedef s11n::node_traits<NODE_TYPE> NT;
                this->name = NT::get( src, "name", this->name );
                this->id = NT::get( src, "id", this->id );
                return true;
        }

};

struct BType : public AType
{
        BType() { classname = "BType"; }
        virtual ~BType() {}

        virtual bool operator()( NODE_TYPE & dest ) const
        {
                typedef s11n::node_traits<NODE_TYPE> NT;
                this->AType::operator()( dest );
                NT::set( dest, "BType_set_this", 1 );
                return true;
        }
};

// s11n proxy
struct AType_s11n
{
        // serialize:
        template <typename NodeT>
        bool operator()( NodeT & dest, const AType & src ) const
        {
                typedef s11n::node_traits<NodeT> NT;
                NT::class_name( dest, src.classname );
                NT::set( dest, "proxy_set_this", 1 );
                NT::set( dest, "name", src.name );
                NT::set( dest, "id", src.id );
                return true;
        }

        // deserialize:
        template <typename NodeT>
        bool operator()( const NodeT & src, AType & dest ) const
        {
                typedef s11n::node_traits<NodeT> NT;
                dest.name = NT::get( src, "name", dest.name );
                dest.id = NT::get( src, "id", dest.id );
                return true;
        }

};

#define USE_APROXY 1

// register our proxies...
#  define S11N_TYPE AType
#  define S11N_TYPE_NAME "AType"
#if USE_APROXY
#  define S11N_SERIALIZE_FUNCTOR AType_s11n
#endif
#include <s11n.net/s11n/reg_serializable.hpp>

#  define S11N_TYPE BType
#  define S11N_BASE_TYPE AType
#  define S11N_TYPE_NAME "BType"
#  include <s11n.net/s11n/reg_serializable.hpp>

// #else
//   // supply some classloader registration...
//   CLLITE_BASE(AType);
//   CLLITE_SUBTYPE(AType,BType);
// #endif // USE_APROXY


void tng_test()
{
        BType a1;
        a1.name = "fred";
        a1.id = 17;

        typedef NODE_TYPE NT;
        NT node;
        assert( (s11n::serialize( node, a1 )) );

        AType * a2 = s11n::deserialize<NT,AType>( node );
        assert( a2 );
        delete( a2 );
        COUT << "Workie!" << std::endl;

//         typedef s11n::io::expat_serializer< NT > SerT;
//         SerT ser;
//         assert( ser.serialize( node, std::cout ) );

        assert( s11nlite::save( node, std::cout ) );

}

int main(int argc, char *argv[])
{

   args = acme::argv_parser::args(argc,argv);
   if (args.is_set("d"))
      cl::class_loader_debug_level(1);

//    if( args.is_set( "t" ) )
//    {
   tng_test();
//    }


   return 0;
}

