//
// vect_of_structs.cpp
//
//
// a minimal example showing how to use s11nlite to
// store an STL vector containing user structs
//
// compiles with:
// g++ -o vect_of_structs vect_of_structs.cpp -I../../../include -L../../../lib 
//  -ls11n



#include "vect_of_structs.h"



int main()
{

  SparseVector v;
  v.add_element(13, 2.3);
  v.add_element(23, 0.3);
  v.add_element(45, 0.13);
  std::cout << "  vector to serialize:" << std::endl;
  v.print();

  // write serialization to cout
  //s11n/s11nlite::save(v, std::cout);


  // serialize the object to disk
  s11nlite::save(v, "my_saved_vect.s11n");


  // okay, let's read it back in...
  SparseVector *v2 = s11nlite::load_serializable<SparseVector>("my_saved_vect.s11n");
  assert(v2);
  std::cout << "  deserialized vector:" << std::endl;
  // write to cout
  //s11n/s11nlite::save(*v2, std::cout);
  v2->print();
  delete v2;




  return 0;
}

