// vect_of_structs.h
//
// see vect_of_structs.cpp for notes
//
//
#ifndef __VECT_OF_STRUCTS__
#define __VECT_OF_STRUCTS__

#include <vector>
#include <iostream>
#include <s11n.net/s11n/s11nlite.hpp>    

// an example struct
struct elem_t {
  int 		index;
  double	value;
  elem_t(void) :  index(-1), value(0.0) {}
  elem_t(int i, double v) : index(i), value(v) {}
  
  // to make our function serializable, just add these operators:
  bool operator()( s11n::data_node &dest  ) const {
    dest.set("i", index);
    dest.set("v", value);
    return true;
  }
  bool operator()( const s11n::data_node &src ) {
    index = src.get("i", -1);
    value = src.get("v", 0.0);
    return true;
  }
};

// Register the elem_t struct with s11n
#define S11N_TYPE elem_t                     // TYPE to proxy
#define S11N_TYPE_NAME "elem_t"                   // type NAME
#include <s11n.net/s11n/reg_serializable.hpp>           // registration code


#include <s11n.net/s11n/list.hpp> // list_serializable_proxy

// we'll want a vector of elem_t in our SparseVector class
typedef std::vector<elem_t> elem_t_vect;

// Tell s11n how to serialize vectors of elem_t
#define S11N_TYPE elem_t_vect
#define S11N_TYPE_NAME "elem_t_vect"
#define S11N_SERIALIZE_FUNCTOR s11n::list::list_serializable_proxy   // use a proxy
#include <s11n.net/s11n/reg_proxy.hpp>


// a class that manages a vector of our structs
class SparseVector
{
public:
  // default constructor, destructor, and copier

  void  add_element(int i, double v) { elements.push_back(elem_t(i, v)); }
  void  print(void) { 
            for (std::vector< elem_t >::iterator i=elements.begin(); 
                             i!=elements.end(); ++i) {
               std::cout << (*i).index << " " << (*i).value << std::endl;
            }         
        }

  // serialization fns
  bool  operator()( s11nlite::node_type &dest) const {       // serialization
    //s11n/s11nlite::serialize_value_list(dest, "vect", elements);  // Use if << and >> defined for elem_t
    //s11n/s11nlite::serialize_list(dest, "vect", elements);
    bool worked = s11nlite::serialize( s11n::create_child(dest, "vect"), elements);
    return worked;
  }
  bool  operator()( const s11nlite::node_type &src) {        // deserialization
    //s11n/s11nlite::deserialize_value_list(src, "vect", elements); // Use if << and >> defined for elem_t
    //s11n/s11nlite::deserialize_list(src, "vect", elements);
    
    const s11nlite::node_type* n = s11nlite::find_child(src, "vect");
    if (!n) { return false; }
    bool worked = s11nlite::deserialize(*n, elements);
    return worked;
  }

private:
  std::vector< elem_t >	elements;
};


// Register this class with the s11n library
// Tell s11n how to handle the SparseVector
#define S11N_TYPE SparseVector
#define S11N_TYPE_NAME "SparseVector"
#include <s11n.net/s11n/reg_serializable.hpp>





#endif // __VECT_OF_STRUCTS__

