#!/bin/bash
infile=${1}
converter=./s11nconvert
formats="compact funtxt funxml parens simplexml"
test x$infile = x && {
    echo "Usage: $0 input file"
    exit 1
}
shift
function bail
{
    echo "$@"
    exit
}
bail="bail $converter returned non-zero."
for F in $formats; do
    echo "Converting $infile to out.$F"
    cmd="time -p $converter -f $infile -s $F $@"
    set -x
    $cmd -o out.$F || $bail
    $cmd -o out.$F.gz -z || $bail
    $cmd -o out.$F.bz -bz || $bail
    set +x
done;
echo 'Serialized Object count: ' $(grep class= out.t | wc -l)

echo "Doing i/o re-serialize comparisons:"
for F in $formats; do 
    echo -n "format '$F'"
    pref=out.
    suf=.check
    ofile=out.$F.check
    $converter -f out.$F -o $ofile -s $F "$@" || $bail
    cmp out.$F $ofile || {
        echo " failed:"
        ls -l $ofile out.$F
        echo "========================================"
        continue;
    }
    rm $ofile
    echo " ok"
done

echo ============================== "Input file and generated files:"
ls -l $infile out.*

echo ============================== "Sorted by size:"
ls -lS $infile out.*
