#!/bin/sh

# Runs some s11nconvert tests.


LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:.:../../
SC="./s11nconvert -DL mysql"
KNOWNS=$(${SC} --known-serializers)
echo "Registered serializers: ${KNOWNS}"
INF=in.demo
spacer="--------------------"
lspacer="$spacer$spacer$spacer$spacer"

runit () {
    echo $@
    $@ || exit
}

for i in ${KNOWNS}; do # or was that UNKNOWN_KNOWNS? ;)

   time {
    echo $lspacer start $i
    runit $SC -f $INF -s $i -o out.$i

    echo "$spacer $i to mysql:"
    runit $SC -s mysql -f $INF -o my.$i

    echo "$spacer $i from mysql: "
    runit $SC -S mysql -f my.$i -s $i -o my.$i

    test -f my.$i && { # won't exist for non-file Serializers
        echo "$spacer Eyeball-compare..."
        runit ls -la out.$i my.$i
    }

    echo "Running time:" # when we exit this { block }
    }
    echo $lspacer end $i

done

