/**
   Demonstration client app for s11nlite.
*/
#define s11n_NO_DEFAULT_POD_REGISTRATIONS 1 // we do this to cut down compile times.
#include <s11n.net/s11n/s11nlite.hpp>
#include <s11n.net/s11n/pods_streamable.hpp>
#include <s11n.net/s11n/map.hpp>
#include <s11n.net/acme/argv_parser.hpp>
#include <s11n.net/acme/random.hpp>
#include <s11n.net/zfstream/zfstream.hpp>
#include <s11n.net/lext/lex_t.hpp>

#include <s11n.net/s11n/s11n_debuggering_macros.hpp> // CERR

#include <time.h>


struct time_saver
{
        
        // serialize
        template <typename NodeT>
        bool operator()( NodeT & dest, const tm & src ) const
        {
                typedef s11n::node_traits<NodeT> TR;
                TR::class_name( dest, "tm" );
                TR::set( dest, std::string("sec"), src.tm_sec );
                TR::set( dest, std::string("min"), src.tm_min );
                TR::set( dest, std::string("hour"), src.tm_hour );
                TR::set( dest, std::string("mday"), src.tm_mday );
                TR::set( dest, std::string("mon"), src.tm_mon );
                TR::set( dest, std::string("year"), src.tm_year );
                TR::set( dest, std::string("wday"), src.tm_wday );
                TR::set( dest, std::string("yday"), src.tm_yday );
                TR::set( dest, std::string("isdst"), src.tm_isdst );
                return true;
        }

        // deserialize
        template <typename NodeT>
        bool operator()( const NodeT & src, tm & dest ) const
        {
                typedef s11n::node_traits<NodeT> TR;
                dest.tm_sec = TR::get( src, std::string("sec"), (int)0 );
                dest.tm_min = TR::get( src, std::string("min"), (int)0 );
                dest.tm_hour = TR::get( src, std::string("hour"), (int)0 );
                dest.tm_mday = TR::get( src, std::string("mday"), (int)0 );
                dest.tm_mon = TR::get( src, std::string("mon"), (int)0 );
                dest.tm_year = TR::get( src, std::string("year"), (int)0 );
                dest.tm_wday = TR::get( src, std::string("wday"), (int)0 );
                dest.tm_yday = TR::get( src, std::string("yday"), (int)0 );
                dest.tm_isdst = TR::get( src, std::string("isdst"), (int)0 );
                return true;
        }
};

std::ostream & operator<<( std::ostream & os, const tm & t )
{
#define DOIO(F) os << t.tm_ ## F << ' ';
        DOIO(sec);
        DOIO(min);
        DOIO(hour);
        DOIO(mday);
        DOIO(mon);
        DOIO(year);
        DOIO(wday);
        DOIO(yday);
#undef DOIO
        os << t.tm_isdst;
        return os;
}

std::istream & operator>>( std::istream & is, tm & t )
{
#define DOIO(F) if( ! (is >> t.tm_ ## F).good() ) return is;
        DOIO(sec);
        DOIO(min);
        DOIO(hour);
        DOIO(mday);
        DOIO(mon);
        DOIO(year);
        DOIO(wday);
        DOIO(yday);
        DOIO(isdst);
#undef DOIO
        return is;
}

#define LEAN_TIME 0
#define S11N_TYPE tm
#define S11N_TYPE_NAME "tm"
#if LEAN_TIME
#  define S11N_SERIALIZE_FUNCTOR s11n::streamable_type_serialization_proxy
#else
#  define S11N_SERIALIZE_FUNCTOR time_saver
#endif
#include <s11n.net/s11n/reg_serializable_traits.hpp>


// #define S11N_TYPE time_t
// #define S11N_TYPE_NAME "time_t"
// #define S11N_SERIALIZE_FUNCTOR time_saver
// // #define S11N_SERIALIZE_FUNCTOR s11n::streamable_type_serialization_proxy
// ^^^^^^^^ won't work because time_t is an int, and already proxied: ODR violation
// #include <s11n.net/s11n/reg_serializable_traits.hpp>


template <typename MapT>
void map2nddel( MapT & map )
{
        typename MapT::iterator b = map.begin(), e = map.end();
        for( ; e != b; ++b )
        {
                delete (*b).second;
        }
}

int main( int argc, char ** argv )
{
        acme::argv_parser & args = acme::argv_parser::args( argc, argv );
        s11nlite::serializer_class( args.get( "s", s11nlite::serializer_class() ) );

        std::string datafile = args.get( "o", "" );

        std::string infile = args.get( "f", "" );

        using lext::lex_t;
        typedef std::map<int,tm> MapT;
        MapT * map = 0;

        if( args.is_set( "z" ) )
        {
                zfstream::compression_policy( zfstream::GZipCompression );
                CERR << "zlib compression enabled.\n";
        }
        else if( args.is_set( "bz" ) )
        {
                zfstream::compression_policy( zfstream::BZipCompression );
                CERR << "bz2lib compression enabled.\n";
        }


        if( ! infile.empty() )
        {
                map = s11nlite::load_serializable<MapT>( infile );
                if( ! map )
                {
                        CERR << "Load failed: " << infile << "\n";
                        return 1;
                }
                CERR << "Load worked\n";
//                 map2nddel( *map );
                return 0;
        }

        if( ! map )
        {
                map = new MapT;
        }

        time_t ttm;
        tm * mytm = 0;
        int count = args.get( "c", 10000 );
        for( int i = 0; i < count; i++ )
        {
                ttm = time(NULL);
                mytm = gmtime( &ttm  );
                if( ! mytm )
                {
                        CERR << "WTF???? Crash!!!\n";
                        return 127;
                }
                (*map)[i] = *mytm;
// WHY DON'T THE FRIGGING TIME DOCS SAY IF I NEED TO FREE THIS POINTER!!!!!!
//                 free( mytm );
// Doing go causes an error "free() invalid pointer 0xXXXXXXXX"
        }


        if( ! datafile.empty()  )
        {
                CERR << "saving ["<<datafile<<"]... ";
                CERR << (s11nlite::save( *map, datafile ) ? "succeeded" : "failed!") << "\n";
        }
        else
        {
                s11nlite::save( *map, std::cout );
        }


//         CERR << "Cleaning up " << count << " tm entries...\n";
//         map2nddel( *map );

        delete map;
        return 0;

}
