////////////////////////////////////////////////////////////////////////
// A test & demo app for s11n[lite].
// Author: stephan@s11n.net
// License: Do As You Damned Well Please
////////////////////////////////////////////////////////////////////////

#ifdef NDEBUG
#  undef NDEBUG // we always want assert() to work
#endif

#include <stdlib.h>// getenv()
#include <cassert>
#include <iostream>
#include <string>
#include <sstream>
 #include <map>


////////////////////////////////////////////////////////////////////////
#include <s11n.net/s11n/s11nlite.hpp> // s11n & s11nlite frameworks
#include <s11n.net/s11n/map.hpp> // map-related functions.
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
#include <s11n.net/lext/lex_t.hpp> // lex_t type
#include <s11n.net/s11n/s11n_debuggering_macros.hpp> // CERR macro
////////////////////////////////////////////////////////////////////////

int
main( int argc, char **argv )
{
        s11nlite::serializer_class( "simplexml" );

        using lext::lex_t;
        typedef std::map<lex_t,lex_t> MapT;
        MapT map;
        map[4] = "one";
        map["one"] = 4;
        map[123] = "eat this";
        map["123"] = "this was re-set";
        map['x'] = "marks the spot";
        map["fred"] = 94.3 * static_cast<double>( map["one"] );
        map["fred"] = 10 * static_cast<double>( map["fred"] );
        int myint = map["one"];
        myint = lex_t(7);
        s11nlite::save( myint, std::cout );



        std::string str = lex_t("Franky goes to C++");
        s11nlite::save( str, std::cout );

        lex_t envvar = "USER";
        CERR << "getenv("<<envvar<<") == " << ::getenv(envvar) << "\n";

        std::ostringstream os; // simulate a file;
        s11nlite::save( map, os );
        CERR << "Map looks like:\n" << os.str() << "\n";

        std::istringstream is( os.str() );
        MapT * read = s11nlite::load_serializable<MapT>( is );

        CERR << "Again, after deserialization:\n";
        s11nlite::save( *read, std::cout );

        delete( read );

        std::string baddbl = "";
        lex_t dtest = lext::Private::from_string( baddbl, -42.42 );
        CERR << "bad double: " << dtest.cast_to<double>() << "\n";

        return 0;
}
