// a supermacro to generate some partial template specializations for list-type classes.

#ifndef S11N_LIST_TYPE
#error "You must define S11N_LIST_TYPE before including this file. e.g., to std::list or std::vector."
#endif

#ifndef S11N_LIST_TYPE_NAME
#error "You must define S11N_LIST_TYPE_NAME before including this file. e.g., to \"list\" or \"vector\"."
#endif

#ifndef S11N_LIST_TYPE_PROXY
#define S11N_LIST_TYPE_PROXY ::s11n::list::list_serializable_proxy
#endif

// #ifndef S11N_LIST_REGISTRATION_FUNC_DEFINED
// #  define S11N_LIST_REGISTRATION_FUNC_DEFINED 1
// namespace s11n {
//         namespace list {
//                 template <typename T>
//                 void register_list_type()
//                 {
//                         const char * cn = ::classname<T>();
//                         CERR << "register_list_type<>("<<cn<<")\n";
//                         ::s11n::cl::classloader_register_base< T >( cn );
//                 }
//         }
// }
// #endif // S11N_LIST_REGISTRATION_FUNC_DEFINED


namespace { // set up ::classname<>()



        ////////////////////////////////////////////////////////////
        // S11N_LIST_TYPE
        template <typename ValueType >
        struct class_name< S11N_LIST_TYPE< ValueType > >
        {
                typedef S11N_LIST_TYPE< ValueType > named_type;
                static const char * name()
                {
                        static bool inited = false;
                        if( (!inited) && (inited=true) )
                        {
                                ::s11n::cl::classloader_register_base< named_type >( S11N_LIST_TYPE_NAME );
                        }
                        return S11N_LIST_TYPE_NAME;
                }
        };

} // anon namespace


namespace s11n {


        /**
           s11n_traits<> specialization for std::list types.
        */
        template <typename ValT >
        struct s11n_traits < S11N_LIST_TYPE<ValT> >
        {
                typedef S11N_LIST_TYPE<ValT> serializable_type;
                typedef S11N_LIST_TYPE_PROXY serialize_functor;
                typedef serialize_functor deserialize_functor;
                typedef ::s11n::cl::object_factory<serializable_type> factory_type;
                static const bool cl_reg_placeholder = (::classname<serializable_type>(),true) ;
        };

} // namespace s11n

#undef S11N_LIST_TYPE_PROXY
#undef S11N_LIST_TYPE_NAME
#undef S11N_LIST_TYPE
