// a supermacro to generate some partial template specializations for map-type classes.

#ifndef S11N_MAP_TYPE
#error "You must define S11N_MAP_TYPE before including this file. e.g., to std::map or std::multimap."
#endif

#ifndef S11N_MAP_TYPE_NAME
#error "You must define S11N_MAP_TYPE_NAME before including this file. e.g., to \"list\" or \"vector\"."
#endif

#ifndef S11N_MAP_TYPE_PROXY
#define S11N_MAP_TYPE_PROXY ::s11n::map::map_serializable_proxy
#endif

namespace { // set up ::classname<>()



        ////////////////////////////////////////////////////////////
        // S11N_MAP_TYPE
        template <typename MapType, typename ValueType>
        struct class_name< S11N_MAP_TYPE<MapType, ValueType> >
        {
                typedef S11N_MAP_TYPE<MapType, ValueType> named_type;
                static const char * name()
                {
                        static bool inited = false;
                        if( (!inited) && (inited=true) )
                        {
                                ::s11n::cl::classloader_register_base< named_type >( S11N_MAP_TYPE_NAME );
                        }
                        return S11N_MAP_TYPE_NAME;
                }
        };

} // anon namespace


namespace s11n {


        /**
           s11n_traits<> specialization for std::map types.
        */
        template <typename KeyT, typename ValT>
        struct s11n_traits < S11N_MAP_TYPE<KeyT,ValT> >
        {
                typedef S11N_MAP_TYPE<KeyT,ValT> serializable_type;
                typedef S11N_MAP_TYPE_PROXY serialize_functor;
                typedef serialize_functor deserialize_functor;
                typedef ::s11n::cl::object_factory<serializable_type> factory_type;
                static const bool cl_reg_placeholder = (::classname<serializable_type>(),true) ;
        };



} // namespace s11n

#undef S11N_MAP_TYPE_PROXY
#undef S11N_MAP_TYPE_NAME
#undef S11N_MAP_TYPE
