#ifndef s11n_S11N_H_INCLUDED
#define s11n_S11N_H_INCLUDED 1

////////////////////////////////////////////////////////////////////////
// s11n.hpp:
// Author: stephan beal <stephan@s11n.net>
// License: Public Domain
//
// This header include "everything most clients would want."
//
// The s11n namespace docs go here so doxygen will pick them up nicely.
////////////////////////////////////////////////////////////////////////

#include <string>

/**
   The s11n serialization (s11n) framework is an object serialization
   framework modelled heavily off work by Rusty Ballinger
   (bozo@users.sourceforge.net http://libfunutil.sourceforge.net). As
   far as i know Rusty was the one to coin the phrase "s11n" (short
   for "serialization", in the same way that i18n is short for
   "internationalization").

   In addition to the class documentation, please see the library
   manual, available in the source tree, in the docs subdir.

   The most important concepts for clients to understand:

   - Data Node, as shown by the reference implementations
   s11n::s11n_node and s11n::data_node.

   - the serialize() and deserialize() family of free functions.

   - type registration, as covered in the library manual.


   See the source tree, under <tt>src/client/sample</tt>, for
   some sample client code.
*/
namespace s11n
{

        /**
           Returns the string form of the s11n library version.
        */
        std::string library_version();

        /**
           The Private namespace holds internal library types: these
           should not be used in client code.
        */
        namespace Private
        {

        }

        /**
           The s11n::io namespace defines some i/o-related types which
           conform to the conventions expected by the
           <code>s11n::de/serialize()</code> core functions. This
           namespace deals with the de/serialization of Data Nodes at
           the stream/file level, leaving the s11n core to only deal
           with de/serialization of containers.

           Clients can swap out these types and still use the core
           s11n interface. The core has no dependencies on this
           namespace. s11nlite combines the s11n core and i/o
           interfaces into a single, easy-to-use API, and users who
           don't <em>need</em> to directly act with the Serializers
           are strongly encouraged to stick to using s11nlite for
           their save/load needs.

           s11n's default Serializer implementations all live
           in the s11n::io namespace, and are derived from
           <code>data_node_serializer<NodeT></code>. Clients
           who subclass this type and follow the conventions
           laid out by the reference implementations can plug
           their own Serializers into the framework with very
           little effort. For an example of a plug-in Serializer
           see the <a href="http://s11n.net/mysql/">mysql_serializer</a>.
        */
        namespace io {
        }
}

#include "s11n_config.hpp"
#include "classload.hpp"
#include "data_node.hpp" // reference Data Node implementation
#include "s11n_node.hpp" // Another reference Data Node implementation
#include "data_node_algo.hpp" // reference NodeType implementation
#include "data_node_serialize.hpp" // serialize() and friends
// #include "data_node_io.hpp" // i/o-related interfaces
// #include "data_node_format.hpp" // tree_builder and related classes
// #include "serializers.hpp" // default serializers/parsers.

#endif // s11n_S11N_H_INCLUDED
