#ifndef s11n_DEBUGGERING_MACROS_H
#define s11n_DEBUGGERING_MACROS_H 1

// CERR is a drop-in replacement for std::cerr, but slightly more
// decorative.
#ifndef CERR
#define CERR std::cerr << __FILE__ << ":" << std::dec << __LINE__ << " : "
#define CERRL(A) CERR << A << std::endl;
#endif

#ifndef COUT
#define COUT std::cout << __FILE__ << ":" << std::dec << __LINE__ << " : "
#define COUTL(A) COUT << A << std::endl;
#endif

#ifndef DTOROUT
#define DTOR_DEBUG 0
#define DTOROUT(CLASSNAME) if(DTOR_DEBUG) CERR << "~" << # CLASSNAME << "() "
#endif

#endif //  s11n_DEBUGGERING_MACROS_H
