
#include <memory> // auto_ptr

#include <s11n.net/zfstream/zfstream.hpp>

#include <s11n.net/s11n/io/data_node_io.hpp>
#include <s11n.net/s11n/io/FlexLexer.hpp>

namespace s11n {
        namespace io {

                namespace Private {

                        int lex_api_hider_yylex( FlexLexer * f, std::istream & is  )
                        {
                                f->switch_streams( & is );
                                int ret = 0;
                                while( 0 != (ret = f->yylex() ) );
                                return ret;
                        }
                }

                std::string get_magic_cookie( const std::string & src, bool AsFile )
                {
                        if( src.empty() ) return src;
                        std::string ret;
                        typedef std::auto_ptr<std::istream> AP;
                        AP is = AP( zfstream::get_istream( src, AsFile ) );
                        if( ! is.get() ) return ret;
                        return ( std::getline( *is, ret ).eof() ? "" : ret ); 
                }

                std::string get_magic_cookie( std::istream & is )
                {
                        std::string ret;
                        if( std::getline( is, ret ).eof() ) return "";
                        return ret;
                }


        } // namespace io
} // namespace s11n
