#include <stdlib.h> // random()
#include <time.h> // time()

#include "random.hpp"


namespace acme {

        unsigned long
        random( unsigned long min,
                unsigned long max )
        {
                static bool unseeded = false;
                if( !unseeded && (unseeded=true) )
                {
                        unsigned long seed = ::time(NULL);
                        ::srandom( seed );
                }
                if( max == min ) return min;
                if( max < min )
                {
                        unsigned long tmp = max;
                        max = min;
                        min = tmp;
                }
                return ( min + ( ::random() % ((unsigned long) (max - min)+1) ) );
        }

        unsigned long
        random( unsigned long max )
        {
                return random( 0L, max );
        }


} // namespace elib
