#ifndef acme_RANDOM_HPP_INCLUDED 
#define acme_RANDOM_HPP_INCLUDED 1

namespace acme {

        /**
           Returns a random number in [min..max] using ::random(). The
           RNG is seeded with the current time before it is used for
           the first time. If you want to force a specific seed,
           call this function once, THEN set your seeed, and it will
           behave as expected.
         */
        unsigned long
        random( unsigned long min, unsigned long max );

        /**
           Returns random number between [0..max]

           max must be >0.
         */
        unsigned long
        random( unsigned long max );

} // namespace acme

#endif // acme_RANDOM_HPP_INCLUDED
