
#include "acme.hpp"
#include "algo.hpp"
#include "aliaser.hpp"
#include "argv_parser.hpp"
#include "children_holder.hpp"
#include "children_server.hpp"
#include "debuggering_macros.hpp"
#include "environment.hpp"
#include "functor.hpp"
#include "key_value_parser.hpp"
#include "pointer_cleaner.hpp"
#include "pointer_list.hpp"
#include "pointer_stripper.hpp"
#include "property_server.hpp"
#include "property_store.hpp"
#include "random.hpp"
#include "uidgen.hpp"

#include <map>
#include <list>
#include <iostream>
#include <string>

#ifdef NDEBUG
#  undef NDEBUG // force assert() to work
#endif
#include <cassert>

#ifndef CERR
#    define CERR std::cerr << __FILE__<<":"<<__LINE__<<": ";
#endif

struct BogoType
{
        BogoType(){};
        virtual ~BogoType()
        {
                CERR << "~BogoType @ " << std::hex<<this<<"\n";
        }
};

bool test_free_map_entries()
{
        typedef std::map<int,BogoType *> MapT;

        MapT map;
        for( int i = 0; i < 5; i++ )
        {
                map[i] = new BogoType;
        }

        acme::free_map_entries( map );

        return true;
}

bool test_free_list_entries()
{
        typedef std::list<BogoType *> ListT;

        ListT list;
        for( int i = 0; i < 5; i++ )
        {
                list.push_back( new BogoType );
        }

        ListT l2;
        std::for_each( list.begin(), list.end(), acme::child_pointer_deep_copier<ListT>(l2) );
        CERR << "Freeing list entries:\n";
        acme::free_list_entries( list );
        CERR << "Freeing l2 entries:\n";
        acme::free_list_entries( l2 );

        return true;
}


int main( int argc, char ** argv )
{
        typedef bool (*testfunc)();
        typedef std::map<std::string,testfunc> FMap;
        FMap fmap;



        fmap["free_map_entries"] = test_free_map_entries;
        fmap["free_list_entries"] = test_free_list_entries;


        if( 1 == argc )
        {
                CERR << "Please pass one of the following arguments:\n";
                FMap::iterator it = fmap.begin(), end = fmap.end();
                for( ; end != it; ++it )
                {
                        std::cerr << "\t" << (*it).first << "\n";
                }
                return 1;
        }

        bool passed = true;
        FMap::iterator it, end = fmap.end();
        std::string arg;
        for( int i = 1; i < argc; i++ )
        {
                arg = argv[i];
                it = fmap.find(arg);
                if( end != it )
                {
                        CERR << "Running test: " << arg << "\n";
                        passed = ((*it).second)();
                        assert( passed );
                        continue;
                }
                CERR << "Unknown argument: " << arg << "\n";
        }

        return passed ? 0 : 1;
}

