////////////////////////////////////////////////////////////////////////
// cl_reg.hpp
// A "supermacro"-style classloader registration snippet for cllite.
////////////////////////////////////////////////////////////////////////
// Macros to be set before including this file:
//
// CL_TYPE: type to be registered.
//
// CL_TYPE_NAME: string name to register CL_TYPE with.
//
// CL_BASE_TYPE: base-most type of CL_TYPE. Defaults to CL_TYPE.
//
// OPTIONAL/special-case macros:
//
// CL_ABSTRACT_BASE: If CL_TYPE is an abstract base class, define this
// macro to any value. If this is set, CL_BASE_TYPE is ignored, as 
// this macro is only intended to be used when CL_TYPE is an abstract
// base.
//
// CL_ALIAS: optional alias string for CL_TYPE_NAME.
//
//
// All macros are #undef'd by this file, so it may be included
// multiple times in succession.
////////////////////////////////////////////////////////////////////////

#ifndef CL_TYPE
#  error "You must define CL_TYPE before including this file."
#endif

#ifndef CL_TYPE_NAME
#  error "You must define CL_TYPE_NAME before including this file."
#endif

#ifndef CL_BASE_TYPE
#  define CL_BASE_TYPE CL_TYPE
#endif

namespace {


#  ifndef cl_CLLITE_REG_CONTEXT_DEFINED
#  define cl_CLLITE_REG_CONTEXT_DEFINED 1
        ///////////////////////////////////////////////////////////////
        // we must not include this more than once per compilation unit
        ///////////////////////////////////////////////////////////////
        // A unique (per Context/per compilation unit) space to assign
        // a bogus value for classloader registration purposes (see
        // the classloader docs for a full description of how this
        // works).
        template <typename Context>
        struct cllite_reg_context
        {
                static bool placeholder;
        };
        template <typename Context> bool cllite_reg_context<Context>::placeholder = false;
#  endif // !cl_CLLITE_REG_CONTEXT_DEFINED

        ////////////////////////////////////////////////////////////////////////
        // Register a factory with the classloader:
	bool cllite_reg_context< CL_TYPE >::placeholder= (
#ifdef CL_ABSTRACT_BASE
                cllite::register_abstract_base< CL_TYPE >( CL_TYPE_NAME ),
#else
	        cllite::register_factory< CL_BASE_TYPE , CL_TYPE >( CL_TYPE_NAME ),
#endif // CL_ABSTRACT_BASE
#ifdef CL_ALIAS
                cllite::alias< CL_TYPE >( CL_ALIAS, CL_TYPE_NAME ),
#endif
                true);

} // anon namespace

#ifdef CL_ABSTRACT_BASE
#  undef CL_ABSTRACT_BASE
#endif

#ifdef CL_ALIAS
#  undef CL_ALIAS
#endif

#undef CL_TYPE
#undef CL_BASE_TYPE
#undef CL_TYPE_NAME
