
////////////////////////////////////////////////////////////////////////////////
// lite.cpp:
// A demonstration app for cllite.
// Author: stephan@s11n.net
// License: Public Domain
////////////////////////////////////////////////////////////////////////////////

#include <stdlib.h> // getenv()

#include <list>
#include <string>

#include "../cllite.hpp" // cllite framework
#include "../cl_debuggering_macros.hpp" // COUT/CERR
#include "../dll_util.hpp"

#include "Driver.hpp" // sample BaseType for demonstating DLLs

int main( int argc, char ** argv )
{

        int dlevel = 0;
        std::string arg;
        for( int i = 1; i < argc; ++i )
        {
                arg = argv[i];
                if( "-d" == arg )
                {
                        dlevel = 1;
                        continue;
                }
                if( "-e" == arg )
                {
                        cllite::use_exceptions( true );
                        continue;
                }
        }
        cl::class_loader_debug_level( dlevel );
        if( ! dlevel )
        {
                CERR << "Use -d to enable extra debug output.\n";
        }

        if( ! cllite::use_exceptions() )
        {
                CERR << "Use -e to enable throwing of exceptions on error.\n";
        }

        CERR << "Exception throwing is " << ( cllite::use_exceptions() ? "EN" : "DIS") << "ABLED" << std::endl;

        // handle -dl DLLNAME and -DL DLLNAME arguments...
        std::list<cllite::dll::dlentry> dlllist;
        if( 0 != cllite::dll::parse_dlentry_flags( argc -1 , argv+1, dlllist ) )
        {
                try
                {
                        if( 0 < cllite::dll::dlload( dlllist ) )
                        {
                                CERR << "dlload(list) failed!\n";
                                return 1;
                        }
                }
                catch( const cllite::cl_exception & ex )
                {
                        std::cerr << ex.what() << "\n";
                        return 1;
                }
        }



        ////////////////////////////////////////////////////////////
        // all of the free functions shown here are defined in
        // the cllite namespace:
        using namespace cllite;

        ////////////////////////////////////////////////////////////
        // Example of altering the class search path:
        // make sure PWD is in there:
        class_path().add_path( getenv("PWD") );

        my::Driver * d = 0;
        std::string cname = "my::DemoDriver";

        try
        {
                d = classload<my::Driver>( cname );
        }
        catch( const cllite::cl_exception & ex )
        {
                CERR << "Classloading exception: " << ex.what() << "\n";
                return 1;
        }

        CERR << "Loaded Driver '"<<cname<<"'? == " << std::hex << d << "\n";

        if( d )
        {
                d->do_something();
        }

        delete d;
        COUT << "Exiting main()." << std::endl;
        return 0;
}

