#!/usr/bin/make -f
# Makefile to build doxygen API docs for the collective libs11n libs.
#
# Requires the following bins in the $(PATH):
# doxygen, libs11n-config, perl


# find_bin: helper function to find $(1) in PATH
find_bin = $(firstword $(wildcard $(addsuffix /$(1),$(subst :, ,$(PATH)))))
DOXYGEN_BIN = $(call find_bin,doxygen)

ifeq (,$(DOXYGEN_BIN))
#    $(warning Error: doxygen not found in PATH: $(PATH))
doxygen:
	@echo "doxygen not found. Cannot build API docs :'("
else


PERL_BIN = $(call find_bin,perl)
ifeq (,$(PERL_BIN))
    $(warning WARNING: perl not found in PATH: $(PATH))
endif

INCLUDE_DIRS = .


Doxyfile: Doxyfile.at index.txt Makefile
	sed -e 's,@PACKAGE_VERSION@,$(PACKAGE_VERSION),;' \
		-e 's,@DOXYGEN_INPUT@,index.txt $(INCLUDE_DIRS),;' \
		-e 's,@PERL@,$(PERL_BIN),;' \
	< $< > $@

.PHONY: html
html: Doxyfile
	@echo "Building docs from headers"
	$(DOXYGEN_BIN)

doxygen: html

CLEAN_FILES += Doxyfile *~ html latex

endif
# ^^^^ doxygen block
