#include <string>
#include <map>
#include <iostream>
#include "lex_t.hpp"

#define COUT std::cout << __FILE__<<":"<<__LINE__<<": "

int main()
{
#define DUMP(A) COUT << # A << "="<<A<<"\n";
        typedef std::map<lext::lex_t,lext::lex_t> MapT;
        MapT map;


        map[4] = "one";
        map["one"] = 4;
        map[123] = "eat this";
        map['x'] = "marks the spot";
        map["fred"] = 94.3 * static_cast<double>( map["one"] );
        map["fred"] = 10 * static_cast<double>( map["fred"] );
        map["123"] = "this was re-set";

        COUT << "Dumping the map...\n";
        MapT::iterator it = map.begin(), et = map.end();
        for( ; et != it; ++it )
        {
                COUT << "map["<<(*it).first<<"] = " << (*it).second<<"\n";
        }
        COUT << "Map dump done.\n";

        int myint = map["one"];
        DUMP(myint);
        myint = map["ooops"];
        DUMP(myint);

        lext::lex_t lex = 17;
        DUMP(lex);
        int bogo = lex;
        DUMP(bogo);
        ulong bogol = bogo * static_cast<long>(lex);
        DUMP(bogol);
        lex = "test string";
        DUMP(lex);
        std::string astring = lex;
        DUMP(astring);

        std::string foo = lex.cast_to( std::string("broken") ); // you shouldn't see "broken"
        foo = lex.cast_to( std::string("double broken") ); // nor this
        DUMP(foo);


        return 0;
}
