#!/usr/bin/make -f
########################################################################
# A set of basic targets for single-dir C++ projects trees.
# Only tested with GNU make and gcc.
#
# Distribution policy:
# Public Domain, of course. No warranties at all: if it destroys your
# data or your marriage, it's your faul (or at least it's not MY fault).
#
# Please send improvements to stephan@s11n.net :)
#
# Usage:
#
# Include it from your Makefile after setting:
#
#  PACKAGE_NAME = single-token name of your project (e.g., libfoo)
#  PACKAGE_VERSION = project version number
#
# These are used when building a distribution tarall.
#
# and optionally:
#  prefix = /installation/prefix
#  DESTDIR = /installation/root
#  CLEAN_FILES += list of files/dirs to delete during 'make clean'
#  DISTCLEAN_FILES += list of files/dirs to delete during 'make distclean'
#  DIST_FILES += list of files/dirs to include in distribution tarball.
#  INSTALL_x and INSTALL_x_DEST, where x is any single token. See below.
#
# Achtung:
# ***** Note the use of "+=" on several of those variables!!!! *****
# ***** BE CAREFUL WHEN USING [DIST]CLEAN_FILES!!!! *****
#
########################################################################
# Installing files:
#
# To install arbitrary files, do this:
#
#    INSTALL_BINS = myapp myotherapp
#    INSTALL_BINS_DEST = $(INSTALL_ROOT)/bin
#    install: install-BINS
# Then:
#    make install[-BINS]
#    make uninstall[-BINS]
#
# Install notes:
#
# - There is nothing magical about the word BINS: any single token can
# be used, and INSTALL_xxx_DEST defaults to INSTALL_ROOT/xxx.
#
# - The installation rules are quite braindead, and simply uses cp to
# install files.
#
#
########################################################################
# Distribution tarball:
#
# To build a dist tarball:
#
#     DIST_FILES += list of files
#
# Then:
#   make dist
#
# If you want to use a non-GNU tar or change the compression type
# (defaults to gzip) then change the TAR_FLAGS variable in this file
# (not in your Makefile).
#
########################################################################
# Building simple binaries directly from sources (no intermediary
# .o files):
#
# myapp_bin_SOURCES = main.cpp whatever.cpp
# myapp: $(myapp_bin_SOURCES) Makefile
# 	@${MAKE} --no-print-directory bin-myapp
#
# If you don't use a sub-make then bin-myapp will be rebuilt even when
# it's not necessary.
#
########################################################################
# Compiling .o files from *.cpp and *.c:
#
#  This file provides rules for building these. See the %.o rules
# for all of the accepted flags.
########################################################################

all:

########################################################################
# Core information:
PACKAGE_NAME ?= "mypackage"
PACKAGE_VERSION ?= "set.PACKAGE_VERSION.var"

BASICMAKE_MAKEFILE = basics.make
DIST_FILES += $(BASICMAKE_MAKEFILE)

FORCE: ; @true

########################################################################
# DESTDIR is for GNU Autotools compatibility...
DESTDIR ?= /
prefix ?= /usr/local
INSTALL_ROOT=$(DESTDIR)$(prefix)

########################################################################
# make_find_bin call()able function:
# $1 = app name
# $2 = optional path
make_find_bin = $(firstword $(wildcard $(addsuffix /$(1),$(subst :, ,$(2) $(PATH)))))
TAR_BIN = $(call make_find_bin,tar)
ifeq (,$(TAR_BIN))
  TAR_BIN = $(call make_find_bin,gtar)
endif


########################################################################
# DIST_FILES stuff...
ifeq (,$(TAR_BIN))
dist:
	@echo "'tar' was not found in the PATH, so i cannot build a dist tarball :(."
else
TAR_FLAGS = czf
TAR_NAME = $(PACKAGE_NAME)-$(PACKAGE_VERSION)
TAR_DIST = $(TAR_NAME).tar.gz
DISTCLEAN_FILES += $(TAR_DIST)
dist:
	@-if test -d $(TAR_NAME); then rm -fr $(TAR_NAME) || exit $$?; fi
	@echo "Creating $(TAR_DIST)..."
	@mkdir $(TAR_NAME)
	@cp -r $(DIST_FILES) $(TAR_NAME)
	@$(TAR_BIN) $(TAR_FLAGS) $(TAR_DIST) $(TAR_NAME)
	@rm -fr $(TAR_NAME)
	@ls -la $(TAR_DIST)
endif
# /dist
########################################################################

########################################################################
# Cleaning up....
clean: FORCE
	@fl="$(wildcard $(CLEAN_FILES))"; \
		test x = "x$$fl" && { echo "Nothing to clean!"; exit 0; }; \
		set -x; rm -fr $$fl
distclean: FORCE
	@fl="$(wildcard $(CLEAN_FILES) $(DISTCLEAN_FILES))"; \
		test x = "x$$fl" && { echo "Nothing to clean!"; exit 0; }; \
		set -x; rm -fr $$fl
########################################################################

########################################################################
# basic_install: $(call)able function:
# $1 = destination dir
# $2 = list of files
basicmake_install = { \
	test -d $(1) || mkdir -p $(1) || exit; \
	for x in $(2); do \
		echo -e "\t" $$x; \
		cp -rp $$x $(1) || exit; \
	done; \
	}
# basic_install: $(call)able function:
# $1 = destination dir
# $2 = list of files to delete
basicmake_uninstall = { \
	test -d $(1) || exit 0; \
	for x in $(2); do \
		echo -e "\t" $$x; \
		rm $(1)/$$x || exit; \
	done; \
	}; \
	test "x" = "x$(1)" && exit 0; \
		echo "Trying to remove empty dir $(1)..."; \
		rmdir $(1) || echo "rmdir failed: $$?! :(";

########################################################################

########################################################################
# install-% installs files listed in $(INSTALL_%) to $(INSTALL_%_DEST),
# which defaults to $(INSTALL_ROOT)/%.
basicmake_get_INSTALL_DEST = $(firstword $(INSTALL_$(1)_DEST) $(INSTALL_ROOT)/$(1))
install-%:
	@echo "Installing INSTALL_$(*) files to $(call basicmake_get_INSTALL_DEST,$(*))..."
	@$(call basicmake_install,\
	$(call basicmake_get_INSTALL_DEST,$(*)),\
	$(INSTALL_$(*)) \
	)
########################################################################
# uninstall-% deletes INSTALL_% from INSTALL_%_DEST, which defaults to
# $(INSTALL_ROOT)/%.
uninstall-%:
	@echo "Uninstalling INSTALL_$(*) files from $(call basicmake_get_INSTALL_DEST,$(*))..."
	@$(call basicmake_uninstall,\
	$(call basicmake_get_INSTALL_DEST,$(*)),\
	$(INSTALL_$(*)) \
	)
########################################################################


########################################################################
# bin-% builds binary % using $(CC). As input it uses vars
# %_bin_SOURCES and %_bin_OBJECTS.
# Passes on flags from these vars:
#   INCLUDES, %_INCLUDES
#   CFLAGS, bin_CLFAGS, %_bin_CFLAGS
#   LDADD, bin_LDADD, %_bin_LDADD
bin-%: FORCE
	@set -x; $(CC) -o $(*) \
		$(INCLUDES) $($(*)_INCLUDES) \
		$($(*)_SOURCES) $($(*)_OBJECTS) \
		$(CFLAGS) $(bin_CFLAGS) $($(*)_CFLAGS) \
		$(LDADD) $(bin_LDADD) $($(*)_LDADD)
# note about 'set -x': i do this because if remove the preceeding @
# then the backslashed-escape newlines are printed in the output.
# Maybe that's a bug, maybe a feature, but it's generally ugly.
########################################################################


########################################################################
# builds %.o from %.c using $(CC).
# Passes on flags from these vars:
#   CFLAGS, %_CFLAGS
#   INCLUDES, %_INCLUDES
#   CPPFLAGS, %_CPPFLAGS
%.o: %.c
	@set -x; \
	$(CC) $(CFLAGS) $($(subst .,_,$*)_CFLAGS) \
		$(INCLUDES) $($(*)_INCLUDES) \
		$(CPPFLAGS) $($(*)_CPPFLAGS) \
		-c -o $@ $<
########################################################################

########################################################################
# builds %.o from %.cpp using $(CXX).
# Passes on flags from these vars:
#   CXXFLAGS, %_CXXFLAGS
#   INCLUDES, %_INCLUDES
#   CPPFLAGS, %_CPPFLAGS
%.o: %.cpp
	@set -x; \
	 $(CXX) $(CXXFLAGS) $($(*)_CXXFLAGS) \
		$(INCLUDES) $($(*)_INCLUDES) \
		$(CPPFLAGS) $($(*)_CPPFLAGS) \
		-c -o $@ $<
########################################################################

