
// #include <pthread.h>     /* pthread functions and data structures */
#include <iostream>
#define CERR std::cerr << __FILE__<<":"<<std::dec<<__LINE__<<": "
#include "sigslot.hpp"
#include <string>
#include <sstream>


struct base_slot : public sigslot::has_slots
{
        typedef sigslot::signal1<const base_slot *> destruction_signal;
        /**
           Clients can connect to this to get signaled when
           this object dies. Note that clients will get a pure
           has_slots object when this is fired, as any
           subclass parts will have already been destroyed by
           the time the client gets this!
        */
        destruction_signal signal_destroyed;
        virtual ~base_slot()
        {
                (this->signal_destroyed)(this);
        }
};


struct slotted : public base_slot
{
        void slot_message( const std::string & m )
        {
                CERR << std::hex << this << "->slot_message(): "<< m << "\n";
        }

};

struct altslotted : public base_slot
{
        void slot_message( const std::string & m )
        {
                CERR << std::hex << this << "->slot_message(): "<< m << "\n";
        }

};

struct hasslots0 : public base_slot
{
        void theslot()
        {
                CERR << std::hex << this << "->theslot()\n";
        }

};

struct hasslots2 : public base_slot
{
        void theslot( const std::string & m, int i )
        {
                CERR << std::hex << this << "->theslot(\""<<m<<"\","<<std::dec<<i<<")\n";
        }

};

struct dtor_watcher // note: not a has_slots type.
{
        void object_destroyed( const base_slot * obj )
        {
                CERR << "(dtor_watcher @ " << std::hex << this << ")->object_destroyed("<<obj<<")\n";
        }

};


void global_slot()
{
        CERR << "global_slot()\n";
}

int test_slots()
{
        CERR << "test_slots():\n";


        ////////////////////////////////////////////////////////////
        // DTorProxy demonstrates signaling a non-has_slots type via
        // a proxy.
        typedef sigslot::slot_proxy1<dtor_watcher,const base_slot *> DTorProxy;
        dtor_watcher dtorw;
        DTorProxy dw( dtorw, &dtor_watcher::object_destroyed );
#define DTOR(X) X.signal_destroyed.connect_slot( &dw, &DTorProxy::proxy_slot );

        ////////////////////////////////////////////////////////////
        // Demonstrate the demo slotted types defined above:
        typedef sigslot::signal1<const std::string &> MsgSig;
        MsgSig sig;
        MsgSig sigcp;
        slotted sl;
        DTOR(sl);
        altslotted * sl2 = new altslotted;
        DTOR((*sl2));
        std::ostringstream os;
        os << std::hex << sl2 << " should not get this.";
        sig.connect_slot( &sl, &slotted::slot_message );
        sig.connect_slot( sl2, &altslotted::slot_message );
        sigcp = sig;
        std::string msg = "What a wonderful slot it is!";
        sig( msg ); sigcp( msg );
        CERR << "^^^^ should see 4 slot_message calls.\n";
        sig.disconnect_slot( sl2 );
        sig( os.str() ); sigcp( os.str() );
        CERR << "^^^^ should see 3 slot_message calls.\n";
        sig.connect_slot( sl2, &altslotted::slot_message );
        sig( msg ); sigcp( msg );
        CERR << "^^^^ should see 4 slot_message calls.\n";
        delete sl2;
        sig( os.str() ); sigcp( os.str() );
        CERR << "^^^^ should see 2 slot_message calls.\n";


        ////////////////////////////////////////////////////////////
        // Demonstrate a 0-arg signal/slot:
        typedef sigslot::signal0 Sig0;
        Sig0 sig0, sig0b;
        hasslots0 h0s;
        DTOR(h0s)
        sig0.connect_slot( &h0s, &hasslots0::theslot );
        typedef sigslot::slot_proxy_func0 FP0;
        FP0 fp0(global_slot);
        sig0.connect_slot( &fp0, &FP0::proxy );
        sig0b = sig0;
        sig0();
        sig0b();

        CERR << "^^^^ should see 2 theslot calls to same object.\n";

        ////////////////////////////////////////////////////////////
        // Demonstrate a 2-arg signal/slot:
        typedef sigslot::signal2<const std::string &, int> Sig2;
        Sig2 sig2, sig2b;
        hasslots2 h2s;
        DTOR(h2s);
        sig2.connect_slot( &h2s, &hasslots2::theslot );
        sig2b = sig2;
        sig2( "2-arg signal", 42 );
        sig2b( "another 2-arg signal", -42 );
        CERR << "^^^^ 2 signals via the same slotted object.\n";
#undef DTOR
        return 0;
}

void * single_slot( void * thread_data )
{
        CERR << "single_slot("<<std::hex<<thread_data<<"):\n";
        typedef sigslot::signal1<const std::string &> MsgSig;
        MsgSig sig;
        slotted sl;
        std::ostringstream os;
        static int count = 0;
        os << "thread @ " << std::hex << thread_data << " sent this: " << count <<".";
        ++count;
        sig.connect_slot( &sl, &slotted::slot_message );
        sig( os.str() );
        return thread_data;
}


#if SIGSLOT_HAS_POSIX_THREADS
#include <list>
void*
thread_test_slots(void* thread_data)
{
        CERR << "thread_test_slots("<<std::hex<<thread_data<<")\n";
        pthread_exit(single_slot(thread_data));
}
#endif


int main_test()
{
#if !(SIGSLOT_HAS_POSIX_THREADS)
        return test_slots();
#else
        typedef std::list<pthread_t *> TList;
        TList threads;
        pthread_t * thr;
        int ret;
        for( int i = 0; i < 5; i++ )
        {
                thr = new pthread_t;
                ret = pthread_create( thr, NULL, thread_test_slots, thr );
                if( 0 != ret )
                {
                        CERR << "Error starting thread!\n";
                        return 1;
                }
                threads.push_back(thr);
        }
        CERR << "main_test() waiting on children threads...\n";
        TList::iterator it = threads.begin(), et = threads.end();
        while( et != it )
        { // wait on threads and clean up their resources...
                // this is not optimal, because it blocks on each join,
                // so we don't really clean up threads AS they shut down.
                ret = pthread_join( *(*it), NULL ); // wait on thread
                CERR << "pthread_join("<<std::hex<<(*it)<<") == " << ret << "\n";
                threads.erase(it); // does this invalidate end()?
                it = threads.begin();
                et = threads.end();
        }
        CERR << "main_test() returning from test thread.\n";
#endif // SIGSLOT_HAS_POSIX_THREADS
        return 0;

}

int main( int argc, char ** argv )
{
        return main_test();
}
