#include <fstream>
#include <iostream>
#include <string>
#include <sstream>

#include "string_util.hpp"


namespace stringutil {

        size_t translate_entities( std::string & str,  const EntityMap & map, bool reverse )
        {
                if( str.empty() || ( 0 == map.size() ) ) return 0;
                size_t count = 0;
                std::string::size_type pos = str.npos;
                EntityMap::const_iterator mit;
                EntityMap::const_iterator met = map.end();

                std::string key;
                std::string val;
                if( reverse )
                {

                        mit = map.begin();
                        for( ; mit != met; ++mit )
                        {
                                key = (*mit).second;
                                val = (*mit).first;
                                while( str.npos != (pos = str.rfind( key )) )
                                {
                                        ++count;
                                        str.replace( pos, key.size(), val );
                                }
                        }
                }
                else
                {
                        pos = str.size() - 1;
                        for( ; pos != std::string::npos; --pos )
                        {
                                mit = map.find( str.substr(pos,1) );
                                if( met == mit ) continue;
                                ++count;
                                str.replace( pos, 1, (*mit).second );
                        }
                }
                return count;
        }

        size_t escape_string( std::string & ins, const std::string & to_esc, const std::string & esc )
        {
                std::string::size_type pos;
                pos = ins.find_first_of( to_esc );
                size_t reps = 0;
                while( pos != std::string::npos )
                {
                        ins.insert( pos, esc );
                        ++reps;
                        pos = ins.find_first_of( to_esc, pos + esc.size() + 1 );
                }
                return reps;
        }



        size_t strip_slashes( std::string &str, const char slash )
        {
                std::string::size_type osz;
                if( str.empty() || ((osz = str.size()) < 2 ) ) return 0;
                std::string::size_type pos = 0;
                size_t count = 0;
                pos = str.find( slash );
                if( pos == str.npos ) return 0;
                if( osz < 2 ) return 0;

                // strip escaped newlines. this is in a separate loop
                // because it used to be in a different function. :/
                pos = osz-2;
                std::string::size_type search;
                while( pos > 2 )
                {
                        char c = str[pos];
                        if( slash == c && (str[pos-1] != slash) )
                        {
                                ++count;
                                search = str.find_first_not_of( " \t\n", pos +1 );
                                if( search > pos + 1 )
                                {
                                        //COUT << "stripping until " << search << ":["<<str.substr(pos,search-pos)<<"]"<<endl;
                                        str.erase( pos, search -pos );
                                }
                                --pos; // one extra.
                        }
                        --pos;
                }
                
                pos = str.find( slash );
                while( !( (pos == std::string::npos) || (pos > str.size()-2) ) )
                {
                        // todo: search from the end, going
                        // backwards. This "might" be faster in terms
                        // of string's required workload.
                        ++count;
                        str.erase( pos, 1 );
                        if( slash != str[pos+1] )
                        {
                                pos += 1;
                        } else pos += 2;
                        pos = str.find( slash, pos );
                }

                return count;
        }

        void normalize_string( std::string &str )
        {
                //COUT << "normalize_string("<<str<<")" << endl;
                trim_string( str );
                strip_slashes( str );
                const char ch = str[0]; 
                if( '"' == ch || '\'' == ch )
                {
                        str.erase( 0, 1 );
                        str.resize( str.size() - 1 );
                }
                //COUT << "normalize_string("<<str<<")" << endl;
                return;
        }



        std::string trim_string( const std::string &str, TrimPolicy policy )
        {
                std::string foo = str;
                trim_string( foo, policy );
                return foo;
        }

        size_t trim_string( std::string &str, TrimPolicy policy )
        {
                if( str.empty() ) return 0;
                static const std::string space(" \t\n\r");
                size_t sc = 0;
                if( policy & TrimTrailing )
                {
                        while( !str.empty() && str.find_last_of( space ) == (str.size()-1) )
                        {
                                str.erase( str.size()-1 );
                                ++sc;
                        }
                }
                if( policy & TrimLeading )
                {
                        while( !str.empty() && (str.find_first_of( space ) == 0 ) )
                        {
                                str.erase( 0, 1 );
                                ++sc;
                        }
                }
                //CERR << "trim_string(...,"<<std::hex<<policy<<") = ["<<str<<"]"<<std::endl;
                return sc;
        }

        std::string
        first_token( const std::string & input )
        {
                if( input.empty() ) return input;
                return input.substr( 0, input.find_first_of( " \n\t" ) );
        }

        std::string
        after_first_token( const std::string & input )
        {
                if( input.empty() ) return input;
                std::string::size_type pos = input.find_first_of( " \n\t" );
                if( pos == std::string::npos ) return std::string();
                return trim_string( input.substr( pos ) );
        }


        int int4hexchar( char c )
        {
                int i = -1;
                if( c >= 48  && c <=57 ) // 0-9
                {
                        i = ((int)c - 48);
                }
                else if( c >= 65  && c <=70 ) // A-F
                {
                        i = ((int)c - 65) + 10;
                }
                else if( c >= 97  && c <=102 ) // a-f
                {
                        i = ((int)c - 97) + 10;
                }

                return i;
        }

        int hex2int( const std::string & wd )
        {
                unsigned int mult = 1;
                int ret = 0;
                char c;
                for( std::string::size_type i = wd.size(); i > 0; --i )
                {
                        //COUT << "i="<<i<<endl;
                        c = wd[i-1];
                        if( '#' == c ) continue;
                        ret += mult * int4hexchar( c );
                        mult = mult * 16;
                }
                return ret;
        }


} //namespace stringutil
