
#ifdef NDEBUG
# undef NDEBUG
#endif
#include <cassert>

#include <iostream>
#include <sstream>
#include "zfstream.hpp"

#define CERR std::cerr << __FILE__ << ":"<<__LINE__<<": "

// template <typename BaseType>
// struct ctor
// {
        
// };

// template <typename BaseType,typename T1>
// struct ctor
// {
//         typedef T1 type_1;
// };

// template <typename BaseType,typename T1, typename T2>
// struct ctor
// {
//         typedef T1 type_1;
//         typedef T2 type_2;

// };




void basic_test()
{

        std::ostringstream data;
        for( int i = 0; i < 5; i++)
        {
                data << i << ": This is data we want to work with.\nArbitrary data. Pay it no mind.\n";
        }

        std::ostream * os = 0;

        using namespace zfstream;

        std::string fbase = std::string("data.");
#define WRITE(Comp) compression_policy(Comp); \
        CERR << "Creating " <<fbase << # Comp << "\n";       \
        os = get_ostream( fbase + # Comp ); \
        assert( os && (std::string( # Comp ) + " write failed.").c_str() ); \
        *os << data.str() << std::endl;                             \
        delete os;

        WRITE(NoCompression);
        WRITE(GZipCompression);
        WRITE(BZipCompression);

#undef WRITE

        std::string str;
        std::istream * is = 0;

#define READ(Comp) \
        CERR << "Reading "<<fbase << # Comp << "...\n";      \
        is = get_istream( fbase + # Comp ); \
        assert( is && (std::string( # Comp ) + " load failed.").c_str() ); \
        while( std::getline( *is, str ) ) { CERR << "getline()="<<str << "\n"; } \
        delete is;

        READ(NoCompression);
        READ(GZipCompression);
        READ(BZipCompression);
#undef READ

}

int main( int argc, char ** argv )
{
        basic_test();

        CERR << "If you made it this far, YOU WIN! :)\n";

        return 0;
}
