#ifndef shellish_INPUT_HPP_INCLUDED
#define shellish_INPUT_HPP_INCLUDED 1

#include <string>
#include <s11n.net/sigslot/sigslot.hpp>

namespace shellish {
        /**
           The input namespace is purely experimental.
        */ 
namespace input {


        struct sharing_context {};

        namespace Private {
                typedef sigslot::signal1<const std::string &> input_signal;

                template <typename ContextType>
                static input_signal & signaler()
                {
                        static input_signal bob;
                        return bob;
                }
        }
        /**
           Causes all connected()ed listeners to get signaled with the
           given input.
        */
        inline void post_message( const std::string & s )
        {
                Private::signaler<sharing_context>()( s );
        }

        /**
           Connects t such that emit("foo") will cause t->slot("foo")
           to be called.

           T must publically inherit sigslot::has_slots&lt;&gt; and have
           an accessible member function matching the slot signature.
        */
        template <typename T>
        static void connect_listener( T * t, void (T::*slot)(const std::string &) )
        {
                Private::signaler<sharing_context>().connect_slot( t, slot );
        }

        /**
           Disconnects t from getting any more messages sent via
           emit().  t is automatically disconnected when it is
           deleted, so there is normally no need to manually
           disconnect.
        */
        template <typename T>
        static void disconnect_listener( T * t )
        {
                Private::signaler<sharing_context>().disconnect_slot( t );
        }


} } // namespace shellish::input


#endif // shellish_INPUT_HPP_INCLUDED
