// shell_process.hpp
#ifndef SHELLISHPROCESS_H_INCLUDED
#define SHELLISHPROCESS_H_INCLUDED
#include <string>
#include <iostream>
namespace shellish {
        using std::string;
/**
shell_process is a front-end for launching things via the shell - part
of the shellish shell app framework and probably not of much use outside
of that context.

Note that it does some behind-the-scenes handling of SIGCHLD to get
rid of zombie processes. If this sounds familiar to you, then please
see the implementation code and make sure that it's default handling
will not collide with any signal handling you do!

License: Public Domain

Author: stephan@s11n.net
*/
        class shell_process 
        {
        public:
                shell_process();
                ~shell_process();

                /**
                   Runs the given command line using popen() and
                   returns 0 on success, or non-zero on failure.  All
                   output generated by the process (to stdout or
                   stderr) will be sent, character by character, to
                   the given outstream.

                   The return value /should/ be that of the exit code
                   from the shell, but it's broken.
                */
                int pipe( const std::string &, std::ostream & os );
                /**
                   calls fork()/exec().

                   The return value is 0 if the fork succeeds or 1 if
                   it fails.
                 */
                int fork( const std::string &, std::ostream & os );
                /**
                   calls ::system(). Note that os is ignored, but
                   provided for API compatibility. It may be used in
                   some way in the future.

                   The return value /should/ be that of the exit code
                   from the system shell.
                 */
                int system( const std::string &, std::ostream & os = std::cout );

       private:
                /**
                   This is a lame workaround to get rid of zombie
                   children.  It is certainly not suitable for
                   all-purpose code, but is useful for all cases where
                   i use this class... so here it is.

                   This is called one time from the shell_process ctor.
                 */
                static void setupSigchldIgnore();


        };
}; // namespace shellish
#endif // SHELLISHPROCESS_H_INCLUDED
